local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// vals
	self.Checked = false;
	
	// convar?
	self.ConVar = nil;
	self.NextCheck = CurTime() + 2.5;
	
	// create label
	self.Label = vgui.Create( "label", self );
	self.Label:SetMouseInputEnabled( false );
	
	// create icon
	self.Icon = vgui.Create( "ctl_icon", self );
	self.Icon:SetMaterial( AppFramework:Theme().icons['close_button'] );
	self.Icon:SetMouseInputEnabled( false );
	self.Icon:SetVisible( false );
	
end

// think
function PANEL:Think( )
	// not yet time to check the convar?
	if( !self.ConVar || self.NextCheck > CurTime() ) then return; end
	self.NextCheck = CurTime() + 2.5;
	
	// check convar
	local var = util.tobool( GetConVarNumber( self.ConVar ) );
	if( var != self.Checked ) then
		self:SetChecked( var );
		
	end

end

// set checked
function PANEL:SetChecked( v )
	// store value.
	self.Checked = v;
	
	// update icon
	self.Icon:SetVisible( self.Checked );
	
	// convar?
	if( self.ConVar ) then
		// convar checked to a 1/0 value.
		local v = 0;
		if( self.Checked ) then v = 1; end
		
		// update.
		LocalPlayer():ConCommand( self.ConVar .. " " .. v .. "\n" );
	
	end
	
end

// get checked
function PANEL:GetChecked( )
	return self.Checked;

end

// set text
function PANEL:SetText( v )
	self.Label:SetText( v );
	
end

// set convar
function PANEL:SetConVar( v )
	self.ConVar = v;

end

// scheme
function PANEL:ApplySchemeSettings( )
	// set fonts and colors
	self.Label:SetFont( AppFramework:Theme().fonts['text'] );
	self.Label:SetFGColor( AppFramework:Theme().colors['text'] );
	
end

// perform layout
function PANEL:PerformLayout( )
	// width/height
	local width, height = self:GetSize();
	
	// size text
	self.Label:SizeToContents();
	self.Label:SetPos(
		8, ( height * 0.5 ) - ( self.Label:GetTall() * 0.5 )
	);
	
	// position icon
	self.Icon:SetPos(
		width - 24,
		( height * 0.5 ) - 8
	);
	self.Icon:SetSize( 16, 16 );
	
	// set my size
	self:SetSize( self:GetWide(), 24 );
	
end

// do click to toggle
function PANEL:OnMouseReleased( )
	// toggle.
	self:SetChecked( !self:GetChecked() );
	
	// run check changed
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnValueChanged", self:GetChecked() );
		
	end
	
end

// draw
function PANEL:Paint( )
	// fetch olors.
	local color = AppFramework:Theme().colors['window_face'];
	local bgcolor = AppFramework:Theme().colors['border_dark'];
	
	// width height
	local width, height = self:GetSize();
	
	
	// square border.
	surface.SetDrawColor(
		bgcolor.r,
		bgcolor.g,
		bgcolor.b,
		bgcolor.a
	);
	surface.DrawRect(
		0, 0,
		width, height
	);
	
	
	// square border.
	surface.SetDrawColor(
		color.r,
		color.g,
		color.b,
		color.a
	);
	surface.DrawRect(
		1, 1,
		width - 2, height - 2
	);
	
	// draw checkbox background.
	local x, y = self.Icon:GetPos();
	AppFramework:Theme():DrawFrame( x - 1, y - 1, 18, 18, FRAME_INSET );

	//
	return true;
	
end

// register
vgui.Register( "ctl_contextcheckbox", PANEL, "Panel" );




// create app framework control.
CtlContextCheckBox_class 	= Control_class:create( nil, false, "ctl_contextcheckbox" );


// set value
function CtlContextCheckBox_class:SetChecked( v )
	self:GetHandle():SetChecked( v );
	
end

// get value
function CtlContextCheckBox_class:GetChecked( )
	return self:GetHandle():GetChecked();
	
end

// set smoothbar
function CtlContextCheckBox_class:SetText( v )
	self:GetHandle():SetText( v );
	
end

// set smoothbar
function CtlContextCheckBox_class:SetConVar( v )
	self:GetHandle():SetConVar( v );
	
end
